//Written by Lord Dalamar & Vinz clortho
using System;
using Server;
using Server.Items;
using Server.Spells.Fifth;
using Server.Spells.Seventh;
using Server.Spells.Necromancy;
using Server.Spells.Ninjitsu;
using Server.Spells.Spellweaving;

namespace Server.Items
{
	public class BraceletofMinax : SilverBracelet
	{
		[Constructable]
		public BraceletofMinax()
		{
			Weight = 5.0;
			Name = "Bracelet of Minax";
			Layer = Layer.Bracelet;
			Hue = 1172;
			Attributes.BonusHits = 15;
			Attributes.RegenHits = 5;
			Attributes.BonusStam = 5;
			Attributes.RegenStam = 5;
			Attributes.WeaponDamage = 25;
		}

		private void ClearTransform( Mobile m )
		{
         m.BodyMod = 0;
         m.HueMod = -1;
         m.NameMod = null;
         m.DisplayGuildTitle = true;
         
         Attributes.BonusStr = 0;
			Attributes.BonusInt = 0;
			Attributes.BonusDex = 0;
			Resistances.Poison = 0;
      }
      
		private void Transform( Mobile m )
		{
         m.SendMessage( "Citis ze se tve telo meni." );
         m.BodyMod = 0x310;
         m.HueMod = -1;
         m.NameMod = "Minion of Minax";
         m.DisplayGuildTitle = false;
         m.Hits = 10;
         m.Mana = 10;
         m.Stam = 10;
         
			Attributes.BonusStr = 20;
			Attributes.BonusInt = 20;
			Attributes.BonusDex = 20;
			Resistances.Poison = 20;
			
			m.PlaySound( 357 );
			m.FixedParticles( 0x376A, 1, 14, 0x13B5, EffectLayer.Waist );
      }
      
		public static bool CheckTransform( Mobile m, int mod )
		{
         if ( m.Mounted )
			{
				m.SendMessage( "Predmet nelze pouzit pokud sedis na zvireti." );
  				return false;
			}
  			else if( Factions.Sigil.ExistsOn( m ) )
  			{
  				m.SendLocalizedMessage( 1061632 ); // You can't do that while carrying the sigil.
  				return false;
  			}
  			else if( !m.CanBeginAction( typeof( PolymorphSpell ) ) )
  			{
  				m.SendLocalizedMessage( 1061628 ); // You can't do that while polymorphed.
  				return false;
  			}
  			else if( TransformationSpell.UnderTransformation( m ) )
  			{
  				m.SendLocalizedMessage( 1063218 ); // You cannot use that ability in this form.
  				return false;
  			}
  			else if( AnimalForm.UnderTransformation( m ) )
  			{
  				m.SendLocalizedMessage( 1063218 ); // You cannot use that ability in this form.
  				return false;
         }
  			else if( !m.CanBeginAction( typeof( IncognitoSpell ) ) )
  			{
  				m.SendLocalizedMessage( 1061630 ); // You can't do that while incognito.
  				return false;
         }
  			else if( ArcaneForm.UnderTransformation( m ) )
  			{
  				m.SendLocalizedMessage( 1063218 ); // You cannot use that ability in this form.
  				return false;
         }
  			else if( m.IsBodyMod && m.BodyMod != mod )
  			{
  				m.SendLocalizedMessage( 1063218 ); // You cannot use that ability in this form.
  				return false;
  			}
  			return true;
      }
      
      public override void OnDoubleClick( Mobile m )
		{
			if( Parent != m )
			{
				m.SendMessage( "Musis mit naramek nasazen aby sel pouzit!" );
			}
			else if( m.HasTrade )
			{
				m.SendMessage( "Nemuzes naramek pouzit pokud s nekym obchodujes!" );
			}
			else
			{
				if ( CheckTransform(  m, 0x310 ) )
				{
					if( m.IsBodyMod && m.BodyMod == 0x310 ) //z demona na cloveka
					{
//                   ClearTransform( m );
                  m.RemoveItem(this);
					   m.EquipItem(this);
					   m.PlaySound( 513 );
			         m.FixedParticles( 0x376A, 1, 14, 0x13B5, EffectLayer.Waist );
                  m.SendMessage( "Ucinek naramku skoncil" );
               }
               else //na demona
               {
					   m.RemoveItem(this);
                  Transform( m );
					   m.EquipItem(this);
               }
				}
			}
		}

        public override void OnRemoved(object parent)
        {
            base.OnRemoved( parent );
            
            if (parent is Mobile)
            {
                Mobile m = (Mobile)parent;
                
                if( m.BodyMod == 0x310 ) //z demona na cloveka
                  ClearTransform( m );
            }
        }

		public BraceletofMinax( Serial serial ) : base( serial )
		{

		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			
			if( Parent is Mobile )
			{
            ((Mobile)Parent).BodyMod = 0;
            ((Mobile)Parent).HueMod = -1;
            ((Mobile)Parent).NameMod = null;
            ((Mobile)Parent).DisplayGuildTitle = true;
            
            Attributes.BonusStr = 0;
            Attributes.BonusInt = 0;
            Attributes.BonusDex = 0;
            Resistances.Poison = 0;
			}
		}
	}
}
